<?php

namespace App\Modules\Risk\RiskAlert;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RiskAlert extends Model 
{

    protected $table = 'risk_alerts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function riskSetting()
    {
        return $this->belongsTo('RiskAlertSetting', 'risk_setting_id');
    }

    public function customer()
    {
        return $this->belongsTo('JackCustomer', 'jack_customer_id');
    }

}